/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PasswordParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.util.Secret;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PasswordParameterDefinition
extends SimpleParameterDefinition {
    @Restricted(value={NoExternalUse.class})
    public static final String DEFAULT_VALUE = "<DEFAULT>";
    private Secret defaultValue;

    @Deprecated
    public PasswordParameterDefinition(@NonNull String name, @CheckForNull String defaultValue, @CheckForNull String description) {
        super(name, description);
        this.defaultValue = Secret.fromString(defaultValue);
    }

    @DataBoundConstructor
    public PasswordParameterDefinition(@NonNull String name, @CheckForNull Secret defaultValueAsSecret, @CheckForNull String description) {
        super(name, description);
        this.defaultValue = defaultValueAsSecret;
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof PasswordParameterValue) {
            PasswordParameterValue value = (PasswordParameterValue)defaultValue;
            return new PasswordParameterDefinition(this.getName(), Secret.toString(value.getValue()), this.getDescription());
        }
        return this;
    }

    @Override
    public ParameterValue createValue(String value) {
        return new PasswordParameterValue(this.getName(), value, this.getDescription());
    }

    @Override
    public PasswordParameterValue createValue(StaplerRequest req, JSONObject jo) {
        PasswordParameterValue value = (PasswordParameterValue)req.bindJSON(PasswordParameterValue.class, jo);
        if (value.getValue().getPlainText().equals(DEFAULT_VALUE)) {
            value = new PasswordParameterValue(this.getName(), this.getDefaultValue());
        }
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue getDefaultParameterValue() {
        return new PasswordParameterValue(this.getName(), this.getDefaultValue(), this.getDescription());
    }

    @NonNull
    public String getDefaultValue() {
        return Secret.toString(this.defaultValue);
    }

    @Restricted(value={DoNotUse.class})
    public Secret getDefaultValueAsSecret() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = Secret.fromString(defaultValue);
    }

    @Override
    public int hashCode() {
        if (PasswordParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(this.getName(), this.getDescription(), this.defaultValue);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_GETCLASS_AND_CLASS_CONSTANT"}, justification="ParameterDefinitionTest tests that subclasses are not equal to their parent classes, so the behavior appears to be intentional")
    public boolean equals(Object obj) {
        if (PasswordParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PasswordParameterDefinition other = (PasswordParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        return Objects.equals(this.defaultValue, other.defaultValue);
    }

    @Extension
    @Symbol(value={"password"})
    public static final class ParameterDescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.PasswordParameterDefinition_DisplayName();
        }
    }
}

