/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.XmlFile;
import hudson.model.AbstractItem;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.listeners.ItemListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessControlled;
import hudson.util.DescriptorList;
import hudson.util.EditDistance;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import jenkins.util.MemoryReductionUtil;
import org.apache.commons.io.FileUtils;
import org.springframework.security.core.Authentication;

public class Items {
    @Deprecated
    public static final List<TopLevelItemDescriptor> LIST = new DescriptorList<TopLevelItem>(TopLevelItem.class);
    private static final ThreadLocal<Boolean> updatingByXml = ThreadLocal.withInitial(() -> false);
    public static final Comparator<Item> BY_NAME = new Comparator<Item>(){

        @Override
        public int compare(Item i1, Item i2) {
            return this.name(i1).compareToIgnoreCase(this.name(i2));
        }

        String name(Item i) {
            Object n = i.getName();
            if (i instanceof ItemGroup) {
                n = (String)n + "/";
            }
            return n;
        }
    };
    public static final Comparator<Item> BY_FULL_NAME = new Comparator<Item>(){

        @Override
        public int compare(Item i1, Item i2) {
            return this.name(i1).compareToIgnoreCase(this.name(i2));
        }

        String name(Item i) {
            Object n = i.getFullName();
            if (i instanceof ItemGroup) {
                n = (String)n + "/";
            }
            return n;
        }
    };
    public static final XStream XSTREAM = new XStream2();
    public static final XStream2 XSTREAM2 = (XStream2)XSTREAM;

    public static <V, T extends Throwable> V whileUpdatingByXml(Callable<V, T> callable) throws T {
        updatingByXml.set(true);
        try {
            Object object = callable.call();
            return (V)object;
        }
        finally {
            updatingByXml.set(false);
        }
    }

    public static boolean currentlyUpdatingByXml() {
        return updatingByXml.get();
    }

    public static DescriptorExtensionList<TopLevelItem, TopLevelItemDescriptor> all() {
        return Jenkins.get().getDescriptorList(TopLevelItem.class);
    }

    public static List<TopLevelItemDescriptor> all(ItemGroup c) {
        return Items.all2(Jenkins.getAuthentication2(), c);
    }

    public static List<TopLevelItemDescriptor> all2(Authentication a, ItemGroup c) {
        ArrayList<TopLevelItemDescriptor> result = new ArrayList<TopLevelItemDescriptor>();
        ACL acl = c instanceof AccessControlled ? ((AccessControlled)((Object)c)).getACL() : Jenkins.get().getACL();
        for (TopLevelItemDescriptor d : Items.all()) {
            if (!acl.hasCreatePermission2(a, c, d) || !d.isApplicableIn(c)) continue;
            result.add(d);
        }
        return result;
    }

    @Deprecated
    public static List<TopLevelItemDescriptor> all(org.acegisecurity.Authentication a, ItemGroup c) {
        return Items.all2(a.toSpring(), c);
    }

    @Deprecated
    public static TopLevelItemDescriptor getDescriptor(String fqcn) {
        return (TopLevelItemDescriptor)Descriptor.find(Items.all(), fqcn);
    }

    public static String toNameList(Collection<? extends Item> items) {
        StringBuilder buf = new StringBuilder();
        for (Item item : items) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(item.getFullName());
        }
        return buf.toString();
    }

    @Deprecated
    public static <T extends Item> List<T> fromNameList(String list, Class<T> type) {
        return Items.fromNameList(null, list, type);
    }

    public static <T extends Item> List<T> fromNameList(ItemGroup context, @NonNull String list, @NonNull Class<T> type) {
        Jenkins jenkins = Jenkins.get();
        ArrayList<T> r = new ArrayList<T>();
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            T item;
            String fullName = tokens.nextToken().trim();
            if (fullName == null || fullName.isEmpty() || (item = jenkins.getItem(fullName, context, type)) == null) continue;
            r.add(item);
        }
        return r;
    }

    public static String getCanonicalName(ItemGroup context, String path) {
        int i;
        String[] c = context.getFullName().split("/");
        String[] p = path.split("/");
        Stack<String> name = new Stack<String>();
        for (i = 0; i < c.length; ++i) {
            if (i == 0 && c[i].equals("")) continue;
            name.push(c[i]);
        }
        for (i = 0; i < p.length; ++i) {
            if (i == 0 && p[i].equals("")) {
                name.clear();
                continue;
            }
            if (p[i].equals("..")) {
                if (name.size() == 0) {
                    throw new IllegalArgumentException(String.format("Illegal relative path '%s' within context '%s'", path, context.getFullName()));
                }
                name.pop();
                continue;
            }
            if (p[i].equals(".")) continue;
            name.push(p[i]);
        }
        return String.join((CharSequence)"/", name);
    }

    public static String computeRelativeNamesAfterRenaming(String oldFullName, String newFullName, String relativeNames, ItemGroup context) {
        StringTokenizer tokens = new StringTokenizer(relativeNames, ",");
        ArrayList<Object> newValue = new ArrayList<Object>();
        while (tokens.hasMoreTokens()) {
            String relativeName = tokens.nextToken().trim();
            String canonicalName = Items.getCanonicalName(context, relativeName);
            if (canonicalName.equals(oldFullName) || canonicalName.startsWith(oldFullName + "/")) {
                String newCanonicalName = newFullName + canonicalName.substring(oldFullName.length());
                if (relativeName.startsWith("/")) {
                    newValue.add("/" + newCanonicalName);
                    continue;
                }
                newValue.add(Items.getRelativeNameFrom(newCanonicalName, context.getFullName()));
                continue;
            }
            newValue.add(relativeName);
        }
        return String.join((CharSequence)",", newValue);
    }

    static String getRelativeNameFrom(String itemFullName, String groupFullName) {
        String[] itemFullNameA = itemFullName.isEmpty() ? MemoryReductionUtil.EMPTY_STRING_ARRAY : itemFullName.split("/");
        String[] groupFullNameA = groupFullName.isEmpty() ? MemoryReductionUtil.EMPTY_STRING_ARRAY : groupFullName.split("/");
        int i = 0;
        while (true) {
            if (i == itemFullNameA.length) {
                if (i == groupFullNameA.length) {
                    return ".";
                }
                StringBuilder b = new StringBuilder();
                for (int j = 0; j < groupFullNameA.length - itemFullNameA.length; ++j) {
                    if (j > 0) {
                        b.append('/');
                    }
                    b.append("..");
                }
                return b.toString();
            }
            if (i == groupFullNameA.length) {
                StringBuilder b = new StringBuilder();
                for (int j = i; j < itemFullNameA.length; ++j) {
                    if (j > i) {
                        b.append('/');
                    }
                    b.append(itemFullNameA[j]);
                }
                return b.toString();
            }
            if (!itemFullNameA[i].equals(groupFullNameA[i])) {
                int j;
                StringBuilder b = new StringBuilder();
                for (j = i; j < groupFullNameA.length; ++j) {
                    if (j > i) {
                        b.append('/');
                    }
                    b.append("..");
                }
                for (j = i; j < itemFullNameA.length; ++j) {
                    b.append('/').append(itemFullNameA[j]);
                }
                return b.toString();
            }
            ++i;
        }
    }

    public static Item load(ItemGroup parent, File dir) throws IOException {
        Item item = (Item)Items.getConfigFile(dir).read();
        item.onLoad(parent, dir.getName());
        return item;
    }

    public static XmlFile getConfigFile(File dir) {
        return new XmlFile(XSTREAM, new File(dir, "config.xml"));
    }

    public static XmlFile getConfigFile(Item item) {
        return Items.getConfigFile(item.getRootDir());
    }

    public static <T extends Item> List<T> getAllItems(ItemGroup root, Class<T> type) {
        return Items.getAllItems(root, type, t -> true);
    }

    public static <T extends Item> List<T> getAllItems(ItemGroup root, Class<T> type, Predicate<T> pred) {
        ArrayList r = new ArrayList();
        Items.getAllItems(root, type, r, pred);
        return r;
    }

    private static <T extends Item> void getAllItems(ItemGroup root, Class<T> type, List<T> r, Predicate<T> pred) {
        ArrayList<Item> items = new ArrayList<Item>(root.getItems(t -> t instanceof ItemGroup || type.isInstance(t) && pred.test((Item)type.cast(t))));
        items.sort(BY_NAME);
        for (Item i : items) {
            if (type.isInstance(i) && pred.test((Item)type.cast(i)) && i.hasPermission(Item.READ)) {
                r.add((Item)type.cast(i));
            }
            if (!(i instanceof ItemGroup)) continue;
            Items.getAllItems((ItemGroup)((Object)i), type, r, pred);
        }
    }

    public static <T extends Item> Iterable<T> allItems(ItemGroup root, Class<T> type) {
        return Items.allItems2(Jenkins.getAuthentication2(), root, type);
    }

    public static <T extends Item> Iterable<T> allItems(ItemGroup root, Class<T> type, Predicate<T> pred) {
        return Items.allItems2(Jenkins.getAuthentication2(), root, type, pred);
    }

    public static <T extends Item> Iterable<T> allItems2(Authentication authentication, ItemGroup root, Class<T> type) {
        return Items.allItems2(authentication, root, type, t -> true);
    }

    @Deprecated
    public static <T extends Item> Iterable<T> allItems(org.acegisecurity.Authentication authentication, ItemGroup root, Class<T> type) {
        return Items.allItems2(authentication.toSpring(), root, type);
    }

    public static <T extends Item> Iterable<T> allItems2(Authentication authentication, ItemGroup root, Class<T> type, Predicate<T> pred) {
        return new AllItemsIterable<T>(root, authentication, type, pred);
    }

    @Deprecated
    public static <T extends Item> Iterable<T> allItems(org.acegisecurity.Authentication authentication, ItemGroup root, Class<T> type, Predicate<T> pred) {
        return Items.allItems2(authentication.toSpring(), root, type, pred);
    }

    @CheckForNull
    public static <T extends Item> T findNearest(Class<T> type, String name, ItemGroup context) {
        ArrayList<String> names = new ArrayList<String>();
        for (Item item : Jenkins.get().allItems(type)) {
            names.add(item.getRelativeNameFrom(context));
        }
        String nearest = EditDistance.findNearest(name, names);
        return Jenkins.get().getItem(nearest, context, type);
    }

    public static <I extends AbstractItem> I move(I item, DirectlyModifiableTopLevelItemGroup destination) throws IOException, IllegalArgumentException {
        DirectlyModifiableTopLevelItemGroup oldParent = (DirectlyModifiableTopLevelItemGroup)item.getParent();
        if (oldParent == destination) {
            throw new IllegalArgumentException();
        }
        if (!destination.canAdd((TopLevelItem)((Object)item))) {
            throw new IllegalArgumentException();
        }
        String name = item.getName();
        Items.verifyItemDoesNotAlreadyExist(destination, name, null);
        String oldFullName = item.getFullName();
        File destDir = destination.getRootDirFor((TopLevelItem)((Object)item));
        FileUtils.forceMkdir((File)destDir.getParentFile());
        FileUtils.moveDirectory((File)item.getRootDir(), (File)destDir);
        oldParent.remove((TopLevelItem)((Object)item));
        I newItem = destination.add(item, name);
        item.movedTo(destination, newItem, destDir);
        ItemListener.fireLocationChange(newItem, oldFullName);
        return newItem;
    }

    static void verifyItemDoesNotAlreadyExist(@NonNull ItemGroup<?> parent, @NonNull String newName, @CheckForNull Item variant) throws IllegalArgumentException, Failure {
        Object existing;
        try (ACLContext ctxt = ACL.as2(ACL.SYSTEM2);){
            existing = parent.getItem(newName);
        }
        if (existing != null && existing != variant) {
            if (existing.hasPermission(Item.DISCOVER)) {
                String prefix = parent.getFullName();
                throw new IllegalArgumentException((String)(prefix.isEmpty() ? "" : prefix + "/") + newName + " already exists");
            }
            throw new Failure("");
        }
    }

    static {
        XSTREAM.alias("project", FreeStyleProject.class);
    }

    private static class AllItemsIterable<T extends Item>
    implements Iterable<T> {
        private final Authentication authentication;
        private final ItemGroup root;
        private final Class<T> type;
        private final Predicate<T> pred;

        private AllItemsIterable(ItemGroup root, Authentication authentication, Class<T> type, Predicate<T> pred) {
            this.root = root;
            this.authentication = authentication;
            this.type = type;
            this.pred = pred;
        }

        @Override
        public Iterator<T> iterator() {
            return new AllItemsIterator();
        }

        private class AllItemsIterator
        implements Iterator<T> {
            private final Stack<ItemGroup> stack = new Stack();
            private Iterator<Item> delegate = null;
            private T next = null;

            private AllItemsIterator() {
                this.stack.push(AllItemsIterable.this.root);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                Item item;
                if (this.next != null) {
                    return true;
                }
                Predicate<Item> search = t -> t instanceof ItemGroup || AllItemsIterable.this.type.isInstance(t) && AllItemsIterable.this.pred.test((Item)AllItemsIterable.this.type.cast(t));
                block5: while (true) {
                    if (this.delegate == null || !this.delegate.hasNext()) {
                        if (this.stack.isEmpty()) {
                            return false;
                        }
                        ItemGroup group = this.stack.pop();
                        if (Jenkins.getAuthentication2().equals(AllItemsIterable.this.authentication)) {
                            this.delegate = group.getItems(search).iterator();
                        } else {
                            try (ACLContext ctx = ACL.as2(AllItemsIterable.this.authentication);){
                                this.delegate = group.getItems(search).iterator();
                            }
                        }
                    }
                    do {
                        if (!this.delegate.hasNext()) continue block5;
                        item = this.delegate.next();
                        if (!(item instanceof ItemGroup)) continue;
                        this.stack.push((ItemGroup)((Object)item));
                    } while (!AllItemsIterable.this.type.isInstance(item) || !AllItemsIterable.this.pred.test((Item)AllItemsIterable.this.type.cast(item)));
                    break;
                }
                this.next = (Item)AllItemsIterable.this.type.cast(item);
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Object t = this.next;
                    return t;
                }
                finally {
                    this.next = null;
                }
            }
        }
    }
}

