/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jsr269;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.jsr269.AbstractProcessorImpl;
import org.kohsuke.stapler.jsr269.PoormansMultimap;

@SupportedAnnotationTypes(value={"org.kohsuke.stapler.export.Exported"})
public class ExportedBeanAnnotationProcessor
extends AbstractProcessorImpl {
    private Set<String> exposedBeanNames;
    static final String STAPLER_BEAN_FILE = "META-INF/exposed.stapler-beans";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                FileObject beans = this.createResource(STAPLER_BEAN_FILE);
                PrintWriter w = new PrintWriter(new OutputStreamWriter(beans.openOutputStream(), StandardCharsets.UTF_8));
                for (String beanName : this.exposedBeanNames) {
                    w.println(beanName);
                }
                w.close();
                return false;
            }
            PoormansMultimap<TypeElement, Element> props = new PoormansMultimap<TypeElement, Element>();
            for (Element element : roundEnv.getElementsAnnotatedWith(Exported.class)) {
                Element type = element.getEnclosingElement();
                if (!type.getKind().isClass() && !type.getKind().isInterface()) continue;
                props.put((TypeElement)type, element);
            }
            if (this.exposedBeanNames == null) {
                this.scanExisting();
            }
            for (Map.Entry entry : props.asMap().entrySet()) {
                this.exposedBeanNames.add(((TypeElement)entry.getKey()).getQualifiedName().toString());
                Properties javadocs = new Properties();
                block9: for (Element md : (Collection)entry.getValue()) {
                    switch (md.getKind()) {
                        case FIELD: 
                        case METHOD: {
                            String javadoc = this.getJavadoc(md);
                            if (javadoc == null) continue block9;
                            javadocs.put(md.getSimpleName().toString(), javadoc);
                            continue block9;
                        }
                    }
                    throw new AssertionError((Object)("Unexpected element type: " + String.valueOf(md)));
                }
                String javadocFile = ((TypeElement)entry.getKey()).getQualifiedName().toString().replace('.', '/') + ".javadoc";
                this.notice("Generating " + javadocFile, (Element)entry.getKey());
                this.writePropertyFile(javadocs, javadocFile);
            }
        }
        catch (IOException x) {
            this.error(x);
        }
        catch (Error | RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void scanExisting() throws IOException {
        this.exposedBeanNames = new TreeSet<String>();
        try {
            String line;
            FileObject beans = this.getResource(STAPLER_BEAN_FILE);
            BufferedReader in = new BufferedReader(new InputStreamReader(beans.openInputStream(), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                this.exposedBeanNames.add(line.trim());
            }
            in.close();
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }
}

