/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.envinject.EnvInjectInfo;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.kohsuke.stapler.DataBoundConstructor;

public class EnvInjectJobPropertyInfo
extends EnvInjectInfo
implements Describable<EnvInjectJobPropertyInfo> {
    @CheckForNull
    private final String scriptFilePath;
    @CheckForNull
    private final String scriptContent;
    @CheckForNull
    private SecureGroovyScript secureGroovyScript;
    private final boolean loadFilesFromMaster;
    @Deprecated
    @CheckForNull
    private transient String groovyScriptContent;

    public EnvInjectJobPropertyInfo() {
        this(null, null, null, null, false, null);
    }

    @DataBoundConstructor
    public EnvInjectJobPropertyInfo(@CheckForNull String propertiesFilePath, @CheckForNull String propertiesContent, @CheckForNull String scriptFilePath, @CheckForNull String scriptContent, boolean loadFilesFromMaster, @CheckForNull SecureGroovyScript secureGroovyScript) {
        super(propertiesFilePath, propertiesContent);
        this.scriptFilePath = Util.fixEmpty((String)scriptFilePath);
        this.scriptContent = this.fixCrLf(Util.fixEmpty((String)scriptContent));
        this.secureGroovyScript = secureGroovyScript != null ? secureGroovyScript.configuringWithNonKeyItem() : null;
        this.loadFilesFromMaster = loadFilesFromMaster;
    }

    @Deprecated
    public EnvInjectJobPropertyInfo(@CheckForNull String propertiesFilePath, @CheckForNull String propertiesContent, @CheckForNull String scriptFilePath, @CheckForNull String scriptContent, @CheckForNull String groovyScriptContent, boolean loadFilesFromMaster) {
        this(propertiesFilePath, propertiesContent, scriptFilePath, scriptContent, loadFilesFromMaster, StringUtils.isNotBlank((String)groovyScriptContent) ? EnvInjectJobPropertyInfo.newSecureGroovyScript(groovyScriptContent) : null);
    }

    private static SecureGroovyScript newSecureGroovyScript(String groovyScriptContent) {
        try {
            return new SecureGroovyScript(groovyScriptContent, false, null).configuring(ApprovalContext.create());
        }
        catch (Descriptor.FormException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckForNull
    public String getScriptFilePath() {
        return this.scriptFilePath;
    }

    @CheckForNull
    public String getScriptContent() {
        return this.scriptContent;
    }

    @CheckForNull
    public SecureGroovyScript getSecureGroovyScript() {
        return this.secureGroovyScript;
    }

    @Deprecated
    @CheckForNull
    public String getGroovyScriptContent() {
        return this.secureGroovyScript != null ? Util.fixEmpty((String)this.secureGroovyScript.getScript()) : null;
    }

    public boolean isLoadFilesFromMaster() {
        return this.loadFilesFromMaster;
    }

    public Descriptor<EnvInjectJobPropertyInfo> getDescriptor() {
        return Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    protected Object readResolve() {
        if (this.secureGroovyScript == null && !StringUtils.isBlank((String)this.groovyScriptContent)) {
            this.secureGroovyScript = EnvInjectJobPropertyInfo.newSecureGroovyScript(this.groovyScriptContent);
            this.groovyScriptContent = null;
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<EnvInjectJobPropertyInfo> {
        public String getDisplayName() {
            return "EnvInjectJobPropertyInfo";
        }
    }
}

