/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.model.HistoricalBuild;
import jenkins.model.queue.QueueItem;

public class HistoryPageEntry<T> {
    private final T entry;

    public HistoryPageEntry(T entry) {
        this.entry = entry;
    }

    public T getEntry() {
        return this.entry;
    }

    public long getEntryId() {
        return HistoryPageEntry.getEntryId(this.entry);
    }

    protected static long getEntryId(@NonNull Object entry) {
        if (entry instanceof QueueItem) {
            return ((QueueItem)entry).getId();
        }
        if (entry instanceof HistoricalBuild) {
            HistoricalBuild run = (HistoricalBuild)entry;
            return Long.MIN_VALUE + (long)run.getNumber();
        }
        if (entry instanceof Number) {
            return Long.MIN_VALUE + ((Number)entry).longValue();
        }
        return -1L;
    }
}

