/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.View;
import hudson.widgets.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.IComputer;
import jenkins.widgets.WidgetFactory;
import org.jenkinsci.Symbol;

public class ExecutorsWidget
extends Widget {
    private final String ownerUrl;
    private final List<IComputer> computers;

    public ExecutorsWidget(@NonNull String ownerUrl, @NonNull List<? extends IComputer> computers) {
        this.ownerUrl = ownerUrl;
        this.computers = new ArrayList<IComputer>(computers);
    }

    @Override
    protected String getOwnerUrl() {
        return this.ownerUrl;
    }

    public List<? extends IComputer> getComputers() {
        return Collections.unmodifiableList(this.computers);
    }

    @Extension(ordinal=100.0)
    @Symbol(value={"executorsComputerSet"})
    public static final class ComputerSetFactoryImpl
    extends WidgetFactory<ComputerSet, ExecutorsWidget> {
        @Override
        public Class<ComputerSet> type() {
            return ComputerSet.class;
        }

        @Override
        public Class<ExecutorsWidget> widgetType() {
            return ExecutorsWidget.class;
        }

        @Override
        @NonNull
        public Collection<ExecutorsWidget> createFor(@NonNull ComputerSet target) {
            return List.of(new ExecutorsWidget("computer/", new ArrayList<IComputer>(target.getComputers())));
        }
    }

    @Extension(ordinal=100.0)
    @Symbol(value={"executorsComputer"})
    public static final class ComputerFactoryImpl
    extends WidgetFactory<Computer, ExecutorsWidget> {
        @Override
        public Class<Computer> type() {
            return Computer.class;
        }

        @Override
        public Class<ExecutorsWidget> widgetType() {
            return ExecutorsWidget.class;
        }

        @Override
        @NonNull
        public Collection<ExecutorsWidget> createFor(@NonNull Computer target) {
            return List.of(new ExecutorsWidget(target.getUrl(), List.of(target)));
        }
    }

    @Extension(ordinal=100.0)
    @Symbol(value={"executors"})
    public static final class ViewFactoryImpl
    extends WidgetFactory<View, ExecutorsWidget> {
        @Override
        public Class<View> type() {
            return View.class;
        }

        @Override
        public Class<ExecutorsWidget> widgetType() {
            return ExecutorsWidget.class;
        }

        @Override
        @NonNull
        public Collection<ExecutorsWidget> createFor(@NonNull View target) {
            return List.of(new ExecutorsWidget(target.getUrl(), target.getComputers()));
        }
    }
}

