/*
 * Decompiled with CFR 0.152.
 */
package jenkins.websocket;

import hudson.Extension;
import hudson.model.InvisibleAction;
import hudson.model.RootAction;
import java.io.IOException;
import java.nio.ByteBuffer;
import jenkins.model.Jenkins;
import jenkins.websocket.WebSocketSession;
import jenkins.websocket.WebSockets;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public class WebSocketEcho
extends InvisibleAction
implements RootAction {
    @Override
    public String getUrlName() {
        return "wsecho";
    }

    public HttpResponse doIndex() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return WebSockets.upgrade(new WebSocketSession(){

            @Override
            protected void text(String message) throws IOException {
                this.sendText("hello " + message);
            }

            @Override
            protected void binary(byte[] payload, int offset, int len) throws IOException {
                ByteBuffer data = ByteBuffer.allocate(len);
                for (int i = 0; i < len; ++i) {
                    byte b = payload[offset + i];
                    if (b >= 97 && b <= 122) {
                        b = (byte)(b - 32);
                    }
                    data.put(i, b);
                }
                this.sendBinary(data);
            }
        });
    }
}

