/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.ChunkedInputStream;
import hudson.util.ChunkedOutputStream;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class FullDuplexHttpService {
    private static final Logger LOGGER = Logger.getLogger(FullDuplexHttpService.class.getName());
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean DIY_CHUNKING = SystemProperties.getBoolean("hudson.diyChunking");
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    protected final UUID uuid;
    private InputStream upload;
    private boolean completed;

    protected FullDuplexHttpService(UUID uuid) {
        this.uuid = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void download(StaplerRequest2 req, StaplerResponse2 rsp) throws InterruptedException, IOException {
        rsp.setStatus(200);
        rsp.addHeader("Transfer-Encoding", "chunked");
        Object out = rsp.getOutputStream();
        if (DIY_CHUNKING) {
            out = new ChunkedOutputStream((OutputStream)out);
        }
        out.write(0);
        out.flush();
        long end = System.currentTimeMillis() + CONNECTION_TIMEOUT;
        while (this.upload == null && System.currentTimeMillis() < end) {
            LOGGER.log(Level.FINE, "Waiting for upload stream for {0}: {1}", new Object[]{this.uuid, this});
            this.wait(1000L);
        }
        if (this.upload == null) {
            throw new IOException("HTTP full-duplex channel timeout: " + String.valueOf(this.uuid));
        }
        LOGGER.log(Level.FINE, "Received upload stream {0} for {1}: {2}", new Object[]{this.upload, this.uuid, this});
        try {
            this.run(this.upload, (OutputStream)out);
        }
        finally {
            this.completed = true;
            this.notify();
        }
    }

    protected abstract void run(InputStream var1, OutputStream var2) throws IOException, InterruptedException;

    public synchronized void upload(StaplerRequest2 req, StaplerResponse2 rsp) throws InterruptedException, IOException {
        rsp.setStatus(200);
        Object in = req.getInputStream();
        if (DIY_CHUNKING) {
            in = new ChunkedInputStream((InputStream)in);
        }
        this.upload = in;
        LOGGER.log(Level.FINE, "Recording upload stream {0} for {1}: {2}", new Object[]{this.upload, this.uuid, this});
        this.notify();
        while (!this.completed) {
            this.wait();
        }
    }

    public static abstract class Response
    extends HttpResponses.HttpResponseException {
        private final Map<UUID, FullDuplexHttpService> services;

        protected Response(Map<UUID, FullDuplexHttpService> services) {
            this.services = services;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
            block8: {
                try {
                    UUID uuid = UUID.fromString(req.getHeader("Session"));
                    rsp.setHeader("Hudson-Duplex", "true");
                    if (req.getHeader("Side").equals("download")) {
                        FullDuplexHttpService service = this.createService(req, uuid);
                        LOGGER.log(Level.FINE, "Processing download side for {0}: {1}", new Object[]{uuid, service});
                        this.services.put(uuid, service);
                        try {
                            service.download(req, rsp);
                        }
                        catch (Throwable throwable) {
                            LOGGER.log(Level.FINE, "Finished download side for {0}: {1}", new Object[]{uuid, service});
                            this.services.remove(uuid);
                            throw throwable;
                        }
                        LOGGER.log(Level.FINE, "Finished download side for {0}: {1}", new Object[]{uuid, service});
                        this.services.remove(uuid);
                        break block8;
                    }
                    FullDuplexHttpService service = this.services.get(uuid);
                    if (service == null) {
                        throw new IOException("No download side found for " + String.valueOf(uuid));
                    }
                    LOGGER.log(Level.FINE, "Processing upload side for {0}: {1}", new Object[]{uuid, service});
                    try {
                        service.upload(req, rsp);
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.FINE, "Finished upload side for {0}: {1}", new Object[]{uuid, service});
                        throw throwable;
                    }
                    LOGGER.log(Level.FINE, "Finished upload side for {0}: {1}", new Object[]{uuid, service});
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }

        protected abstract FullDuplexHttpService createService(StaplerRequest2 var1, UUID var2) throws IOException, InterruptedException;
    }
}

