/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.InvisibleAction;
import hudson.model.RootAction;
import java.time.LocalDate;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.telemetry.Telemetry;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Restricted(value={NoExternalUse.class})
public class HttpExtensionList
extends Telemetry {
    private final Map<String, Integer> calls = new ConcurrentHashMap<String, Integer>();

    @Override
    @NonNull
    public String getDisplayName() {
        return "Extension List access via HTTP";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2025, 4, 5);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2025, 7, 1);
    }

    @Override
    public synchronized JSONObject createContent() {
        JSONObject info = new JSONObject();
        info.put("components", this.buildComponentInformation());
        TreeMap<String, Integer> currentRequests = new TreeMap<String, Integer>(this.calls);
        this.calls.clear();
        JSONObject payload = new JSONObject();
        payload.putAll(currentRequests);
        info.put("dispatches", (Object)payload);
        return info;
    }

    public synchronized void record(String path) {
        String[] parts = ((String)path).split("/");
        if (parts.length > 1) {
            path = parts[0] + "/" + parts[1];
        }
        this.calls.compute((String)path, (p, v) -> v == null ? 1 : v + 1);
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class ExtensionListRootAction
    extends InvisibleAction
    implements RootAction {
        private static final Logger LOGGER = Logger.getLogger(ExtensionListRootAction.class.getName());

        @Override
        public String getUrlName() {
            return "extensionList";
        }

        public ExtensionList getDynamic(String extensionType) throws ClassNotFoundException {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            if (req != null && extensionType != null) {
                try {
                    HttpExtensionList telemetry = ExtensionList.lookupSingleton(HttpExtensionList.class);
                    if (telemetry.isActivePeriod()) {
                        telemetry.record(extensionType + req.getRestOfPath());
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to record telemetry for " + HttpExtensionList.class.getName(), ex);
                }
            }
            return Jenkins.get().getExtensionList(extensionType);
        }
    }
}

