/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jenkins.security.QueueItemAuthenticator;

public abstract class QueueItemAuthenticatorProvider
implements ExtensionPoint {
    @NonNull
    public abstract List<QueueItemAuthenticator> getAuthenticators();

    public static Iterable<QueueItemAuthenticator> authenticators() {
        return new IterableImpl();
    }

    private static class IterableImpl
    implements Iterable<QueueItemAuthenticator> {
        private IterableImpl() {
        }

        @Override
        public Iterator<QueueItemAuthenticator> iterator() {
            return new IteratorImpl();
        }
    }

    private static class IteratorImpl
    implements Iterator<QueueItemAuthenticator> {
        private final Iterator<QueueItemAuthenticatorProvider> providers = ExtensionList.lookup(QueueItemAuthenticatorProvider.class).iterator();
        private Iterator<QueueItemAuthenticator> delegate = null;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            while ((this.delegate == null || !this.delegate.hasNext()) && this.providers.hasNext()) {
                QueueItemAuthenticatorProvider provider = this.providers.next();
                if (provider == null) continue;
                this.delegate = new ArrayList<QueueItemAuthenticator>(provider.getAuthenticators()).iterator();
            }
            return this.delegate != null && this.delegate.hasNext();
        }

        @Override
        public QueueItemAuthenticator next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

