/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.function.Function;
import org.acegisecurity.AcegiSecurityException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.CompatibleFilter;

@Restricted(value={NoExternalUse.class})
public class AcegiSecurityExceptionFilter
implements CompatibleFilter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (IOException x) {
            throw AcegiSecurityExceptionFilter.translate(x, IOException::new);
        }
        catch (ServletException x) {
            throw AcegiSecurityExceptionFilter.translate(x, ServletException::new);
        }
        catch (RuntimeException x) {
            throw AcegiSecurityExceptionFilter.translate(x, RuntimeException::new);
        }
    }

    private static <T extends Throwable> T translate(T t, Function<Throwable, T> ctor) {
        RuntimeException cause = AcegiSecurityExceptionFilter.convertedCause(t);
        if (cause != null) {
            Throwable t2 = (Throwable)ctor.apply(cause);
            t2.addSuppressed(t);
            return (T)t2;
        }
        return t;
    }

    @CheckForNull
    private static RuntimeException convertedCause(@CheckForNull Throwable t) {
        if (t instanceof AcegiSecurityException) {
            return ((AcegiSecurityException)((Object)t)).toSpring();
        }
        if (t != null) {
            return AcegiSecurityExceptionFilter.convertedCause(t.getCause());
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

