/*
 * Decompiled with CFR 0.152.
 */
package jenkins.search;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.ModelObject;
import jenkins.search.Messages;

public interface SearchGroup
extends ExtensionPoint,
ModelObject {
    public static ExtensionList<SearchGroup> all() {
        return ExtensionList.lookup(SearchGroup.class);
    }

    @NonNull
    public static <T extends SearchGroup> T get(Class<T> type) {
        SearchGroup category = (SearchGroup)SearchGroup.all().get(type);
        if (category == null) {
            throw new AssertionError((Object)("Group not found. It seems the " + String.valueOf(type) + " is not annotated with @Extension and so not registered"));
        }
        return (T)category;
    }

    @Extension
    public static class UserSearchGroup
    implements SearchGroup {
        @Override
        public String getDisplayName() {
            return Messages.SearchGroup_UserSearchGroup_DisplayName();
        }
    }

    @Extension
    public static class ViewSearchGroup
    implements SearchGroup {
        @Override
        public String getDisplayName() {
            return Messages.SearchGroup_ViewSearchGroup_DisplayName();
        }
    }

    @Extension
    public static class ComputerSearchGroup
    implements SearchGroup {
        @Override
        public String getDisplayName() {
            return Messages.SearchGroup_ComputerSearchGroup_DisplayName();
        }
    }

    @Extension(ordinal=999.0)
    public static class ItemSearchGroup
    implements SearchGroup {
        @Override
        public String getDisplayName() {
            return Messages.SearchGroup_ItemSearchGroup_DisplayName();
        }
    }

    @Extension(ordinal=-1.0)
    public static class UnclassifiedSearchGroup
    implements SearchGroup {
        @Override
        public String getDisplayName() {
            return Messages.SearchGroup_UnclassifiedSearchGroup_DisplayName();
        }
    }
}

