/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.BallColor;
import hudson.model.BuildBadgeAction;
import hudson.model.ModelObject;
import hudson.model.ParameterValue;
import hudson.model.Result;
import java.util.Calendar;
import java.util.List;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface HistoricalBuild
extends ModelObject {
    public int getNumber();

    @NonNull
    public String getUrl();

    @CheckForNull
    public String getDescription();

    @NonNull
    public String getFullDisplayName();

    public long getQueueId();

    @CheckForNull
    public Result getResult();

    @NonNull
    public List<ParameterValue> getParameterValues();

    public boolean isBuilding();

    @NonNull
    public BallColor getIconColor();

    @NonNull
    default public String getBuildStatusIconClassName() {
        return this.getIconColor().getIconClassName();
    }

    @NonNull
    default public String getBuildStatusUrl() {
        return this.getIconColor().getImage();
    }

    @NonNull
    public Calendar getTimestamp();

    @NonNull
    public String getDurationString();

    @NonNull
    public List<BuildBadgeAction> getBadgeActions();

    @CheckForNull
    default public String getTruncatedDescription() {
        String description = this.getDescription();
        int truncatedDescriptionLimit = SystemProperties.getInteger("historyWidget.descriptionLimit", 100);
        if (truncatedDescriptionLimit < 0) {
            return description;
        }
        if (truncatedDescriptionLimit == 0) {
            return "";
        }
        if (description == null || description.length() < truncatedDescriptionLimit) {
            return description;
        }
        String ending = "...";
        int sz = description.length();
        int maxTruncLength = truncatedDescriptionLimit - "...".length();
        boolean inTag = false;
        int displayChars = 0;
        int lastTruncatablePoint = -1;
        for (int i = 0; i < sz; ++i) {
            char ch = description.charAt(i);
            if (ch == '<') {
                inTag = true;
            } else if (ch == '>') {
                inTag = false;
                if (displayChars <= maxTruncLength) {
                    lastTruncatablePoint = i + 1;
                }
            }
            if (inTag || ++displayChars > maxTruncLength || ch != ' ') continue;
            lastTruncatablePoint = i;
        }
        Object truncDesc = description;
        if (lastTruncatablePoint == -1) {
            lastTruncatablePoint = maxTruncLength;
        }
        if (displayChars >= truncatedDescriptionLimit) {
            truncDesc = ((String)truncDesc).substring(0, lastTruncatablePoint) + "...";
        }
        return truncDesc;
    }
}

