/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.User;
import java.util.Map;

@Extension
public class DefaultUserCanonicalIdResolver
extends User.CanonicalIdResolver {
    public static final Descriptor<User.CanonicalIdResolver> DESCRIPTOR = new Descriptor<User.CanonicalIdResolver>(){

        @Override
        @NonNull
        public String getDisplayName() {
            return "compute default user ID";
        }
    };

    @Override
    public String resolveCanonicalId(String idOrFullName, Map<String, ?> context) {
        String id = idOrFullName.replace('\\', '_').replace('/', '_').replace('<', '_').replace('>', '_');
        if (Functions.isWindows()) {
            id = id.replace(':', '_');
        }
        return id;
    }

    @Override
    public int getPriority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Descriptor<User.CanonicalIdResolver> getDescriptor() {
        return DESCRIPTOR;
    }
}

