/*
 * Decompiled with CFR 0.152.
 */
package jenkins.install;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.DownloadService;
import hudson.model.PageDecorator;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.model.User;
import hudson.security.AccountCreationFailedException;
import hudson.security.FullControlOnceLoggedInAuthorizationStrategy;
import hudson.security.HudsonPrivateSecurityRealm;
import hudson.security.SecurityRealm;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.GlobalCrumbIssuerConfiguration;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.PluginServletFilter;
import hudson.util.VersionNumber;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.install.InstallState;
import jenkins.install.InstallUtil;
import jenkins.install.Messages;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.security.ApiTokenProperty;
import jenkins.security.apitoken.TokenUuidAndPlainValue;
import jenkins.security.seed.UserSeedProperty;
import jenkins.util.SystemProperties;
import jenkins.util.UrlHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.CompatibleFilter;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Restricted(value={NoExternalUse.class})
@Extension
public class SetupWizard
extends PageDecorator {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in several plugins")
    public static String initialSetupAdminUserName = "admin";
    private static final Logger LOGGER = Logger.getLogger(SetupWizard.class.getName());
    private static final String ADMIN_INITIAL_API_TOKEN_PROPERTY_NAME = SetupWizard.class.getName() + ".adminInitialApiToken";
    @Restricted(value={NoExternalUse.class})
    private static String ADMIN_INITIAL_API_TOKEN = SystemProperties.getString(ADMIN_INITIAL_API_TOKEN_PROPERTY_NAME);
    private final Filter FORCE_SETUP_WIZARD_FILTER = new CompatibleFilter(){

        public void init(FilterConfig cfg) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (request instanceof HttpServletRequest && !Jenkins.get().getInstallState().isSetupComplete()) {
                HttpServletRequest req = (HttpServletRequest)request;
                String requestURI = req.getRequestURI();
                if (requestURI.equals(req.getContextPath()) && !requestURI.endsWith("/")) {
                    ((HttpServletResponse)response).sendRedirect(req.getContextPath() + "/");
                    return;
                }
                if (req.getRequestURI().equals(req.getContextPath() + "/")) {
                    Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                    chain.doFilter((ServletRequest)new HttpServletRequestWrapper(req){

                        public String getRequestURI() {
                            return this.getContextPath() + "/setupWizard/";
                        }
                    }, response);
                    return;
                }
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };

    public SetupWizard() {
        this.checkFilter();
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return Messages.SetupWizard_DisplayName();
    }

    void init(boolean newInstall) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.get();
        if (newInstall) {
            FilePath iapf = this.getInitialAdminPasswordFile();
            if (jenkins.getSecurityRealm() == null || jenkins.getSecurityRealm() == SecurityRealm.NO_AUTHENTICATION) {
                try (BulkChange bc = new BulkChange(jenkins);){
                    HudsonPrivateSecurityRealm securityRealm = new HudsonPrivateSecurityRealm(false, false, null);
                    jenkins.setSecurityRealm(securityRealm);
                    String randomUUID = UUID.randomUUID().toString().replace("-", "").toLowerCase(Locale.ENGLISH);
                    User initialAdmin = securityRealm.createAccount(initialSetupAdminUserName, randomUUID);
                    if (ADMIN_INITIAL_API_TOKEN != null) {
                        this.createInitialApiToken(initialAdmin);
                    }
                    iapf.touch(System.currentTimeMillis());
                    iapf.chmod(416);
                    iapf.write(randomUUID + System.lineSeparator(), "UTF-8");
                    FullControlOnceLoggedInAuthorizationStrategy authStrategy = new FullControlOnceLoggedInAuthorizationStrategy();
                    authStrategy.setAllowAnonymousRead(false);
                    jenkins.setAuthorizationStrategy(authStrategy);
                    jenkins.setSlaveAgentPort(SystemProperties.getInteger(Jenkins.class.getName() + ".slaveAgentPort", -1));
                    jenkins.setCrumbIssuer(GlobalCrumbIssuerConfiguration.createDefaultCrumbIssuer());
                    jenkins.save();
                    bc.commit();
                }
            }
            if (iapf.exists()) {
                String setupKey = iapf.readToString().trim();
                String ls = System.lineSeparator();
                LOGGER.info(ls + ls + "*************************************************************" + ls + "*************************************************************" + ls + "*************************************************************" + ls + ls + "Jenkins initial setup is required. An admin user has been created and a password generated." + ls + "Please use the following password to proceed to installation:" + ls + ls + setupKey + ls + ls + "This may also be found at: " + iapf.getRemote() + ls + ls + "*************************************************************" + ls + "*************************************************************" + ls + "*************************************************************" + ls);
            }
        }
        try {
            UpdateCenter.updateDefaultSite();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void createInitialApiToken(User user) throws IOException, InterruptedException {
        ApiTokenProperty apiTokenProperty = user.getProperty(ApiTokenProperty.class);
        String sysProp = ADMIN_INITIAL_API_TOKEN;
        if (sysProp.equals("true")) {
            TokenUuidAndPlainValue tokenUuidAndPlainValue = apiTokenProperty.generateNewToken("random-generation-during-setup-wizard");
            FilePath fp = this.getInitialAdminApiTokenFile();
            fp.touch(System.currentTimeMillis());
            fp.chmod(416);
            fp.write(tokenUuidAndPlainValue.plainValue, StandardCharsets.UTF_8.name());
            LOGGER.log(Level.INFO, "The API Token was randomly generated and the information was put in {0}", fp.getRemote());
        } else {
            String plainText;
            if (sysProp.startsWith("@")) {
                Path apiTokenFile;
                String apiTokenStr = sysProp.substring(1);
                try {
                    apiTokenFile = Paths.get(apiTokenStr, new String[0]);
                }
                catch (InvalidPathException e) {
                    LOGGER.log(Level.WARNING, "The API Token cannot be retrieved from an invalid path: {0}", apiTokenStr);
                    return;
                }
                if (!Files.exists(apiTokenFile, new LinkOption[0])) {
                    LOGGER.log(Level.WARNING, "The API Token cannot be retrieved from a non-existing file: {0}", apiTokenFile);
                    return;
                }
                try {
                    plainText = Files.readString(apiTokenFile, StandardCharsets.UTF_8);
                    LOGGER.log(Level.INFO, "API Token generated using contents of file: {0}", apiTokenFile.toAbsolutePath());
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, String.format("The API Token cannot be retrieved from the file: %s", apiTokenFile), e);
                    return;
                }
            }
            LOGGER.log(Level.INFO, "API Token generated using system property: {0}", ADMIN_INITIAL_API_TOKEN_PROPERTY_NAME);
            plainText = sysProp;
            try {
                apiTokenProperty.addFixedNewToken("fix-generation-during-setup-wizard", plainText);
            }
            catch (IllegalArgumentException e) {
                String constraintFailureMessage = e.getMessage();
                LOGGER.log(Level.WARNING, "The API Token cannot be generated using the provided value due to: {0}", constraintFailureMessage);
            }
        }
    }

    private void setUpFilter() {
        try {
            if (!PluginServletFilter.hasFilter(this.FORCE_SETUP_WIZARD_FILTER)) {
                PluginServletFilter.addFilter(this.FORCE_SETUP_WIZARD_FILTER);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add PluginServletFilter for the SetupWizard", e);
        }
    }

    private void tearDownFilter() {
        try {
            if (PluginServletFilter.hasFilter(this.FORCE_SETUP_WIZARD_FILTER)) {
                PluginServletFilter.removeFilter(this.FORCE_SETUP_WIZARD_FILTER);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to remove PluginServletFilter for the SetupWizard", e);
        }
    }

    public boolean isUsingSecurityToken() {
        try {
            return !Jenkins.get().getInstallState().isSetupComplete() && this.isUsingSecurityDefaults();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    boolean isUsingSecurityDefaults() {
        Jenkins j = Jenkins.get();
        if (j.getSecurityRealm() instanceof HudsonPrivateSecurityRealm) {
            HudsonPrivateSecurityRealm securityRealm = (HudsonPrivateSecurityRealm)j.getSecurityRealm();
            try {
                if (securityRealm.getAllUsers().size() == 1) {
                    HudsonPrivateSecurityRealm.Details details = securityRealm.load(initialSetupAdminUserName);
                    FilePath iapf = this.getInitialAdminPasswordFile();
                    if (iapf.exists() && details.isPasswordCorrect(iapf.readToString().trim())) {
                        return true;
                    }
                }
            }
            catch (IOException | InterruptedException | UsernameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doCreateAdminUser(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        HudsonPrivateSecurityRealm securityRealm = (HudsonPrivateSecurityRealm)j.getSecurityRealm();
        User admin = securityRealm.getUser(initialSetupAdminUserName);
        try {
            ApiTokenProperty initialApiTokenProperty = null;
            if (admin != null) {
                initialApiTokenProperty = admin.getProperty(ApiTokenProperty.class);
                admin.delete();
            }
            User newUser = securityRealm.createAccountFromSetupWizard(req);
            if (admin != null) {
                admin = null;
            }
            if (initialApiTokenProperty != null) {
                newUser.addProperty(initialApiTokenProperty);
            }
            try {
                this.getInitialAdminPasswordFile().delete();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            try {
                FilePath fp = this.getInitialAdminApiTokenFile();
                if (fp.exists()) {
                    fp.delete();
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            InstallUtil.proceedToNextStateFrom(InstallState.CREATE_ADMIN_USER);
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)newUser.getId(), (Object)req.getParameter("password1"));
            auth = securityRealm.getSecurityComponents().manager2.authenticate((Authentication)auth);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            HttpSession session = req.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            HttpSession newSession = req.getSession(true);
            UserSeedProperty userSeed = newUser.getProperty(UserSeedProperty.class);
            String sessionSeed = userSeed.getSeed();
            newSession.setAttribute("_JENKINS_SESSION_SEED", (Object)sessionSeed);
            CrumbIssuer crumbIssuer = Jenkins.get().getCrumbIssuer();
            JSONObject data = new JSONObject();
            if (crumbIssuer != null) {
                data.accumulate("crumbRequestField", (Object)crumbIssuer.getCrumbRequestField()).accumulate("crumb", (Object)crumbIssuer.getCrumb((ServletRequest)req));
            }
            HttpResponse httpResponse = HttpResponses.okJSON(data);
            return httpResponse;
        }
        catch (AccountCreationFailedException e) {
            rsp.setStatus(422);
            ForwardToView forwardToView = HttpResponses.forwardToView((Object)securityRealm, (String)"/jenkins/install/SetupWizard/setupWizardFirstUser.jelly");
            return forwardToView;
        }
        finally {
            if (admin != null) {
                admin.save();
            }
        }
    }

    @POST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doConfigureInstance(StaplerRequest2 req, @QueryParameter String rootUrl) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        HashMap<String, String> errors = new HashMap<String, String>();
        this.checkRootUrl(errors, rootUrl);
        if (!errors.isEmpty()) {
            return HttpResponses.errorJSON(Messages.SetupWizard_ConfigureInstance_ValidationErrors(), errors);
        }
        this.useRootUrl(errors, rootUrl);
        if (!errors.isEmpty()) {
            return HttpResponses.errorJSON(Messages.SetupWizard_ConfigureInstance_ValidationErrors(), errors);
        }
        InstallUtil.proceedToNextStateFrom(InstallState.CONFIGURE_INSTANCE);
        CrumbIssuer crumbIssuer = Jenkins.get().getCrumbIssuer();
        JSONObject data = new JSONObject();
        if (crumbIssuer != null) {
            data.accumulate("crumbRequestField", (Object)crumbIssuer.getCrumbRequestField()).accumulate("crumb", (Object)crumbIssuer.getCrumb((ServletRequest)req));
        }
        return HttpResponses.okJSON(data);
    }

    private void checkRootUrl(Map<String, String> errors, @CheckForNull String rootUrl) {
        if (rootUrl == null) {
            errors.put("rootUrl", Messages.SetupWizard_ConfigureInstance_RootUrl_Empty());
            return;
        }
        if (!UrlHelper.isValidRootUrl(rootUrl)) {
            errors.put("rootUrl", Messages.SetupWizard_ConfigureInstance_RootUrl_Invalid());
        }
    }

    private void useRootUrl(Map<String, String> errors, @CheckForNull String rootUrl) {
        LOGGER.log(Level.FINE, "Root URL set during SetupWizard to {0}", new Object[]{rootUrl});
        JenkinsLocationConfiguration.getOrDie().setUrl(rootUrl);
    }

    void setCurrentLevel(VersionNumber v) throws IOException {
        Files.writeString(Util.fileToPath(SetupWizard.getUpdateStateFile()), (CharSequence)v.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    static File getUpdateStateFile() {
        return new File(Jenkins.get().getRootDir(), "jenkins.install.UpgradeWizard.state");
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public VersionNumber getCurrentLevel() {
        VersionNumber from = new VersionNumber("1.0");
        File state = SetupWizard.getUpdateStateFile();
        if (state.exists()) {
            try {
                String version = Files.readString(Util.fileToPath(state), StandardCharsets.UTF_8);
                if (version == null || version.isBlank()) {
                    version = "1.0";
                }
                from = new VersionNumber(version.trim());
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Cannot read the current version file", ex);
                return null;
            }
        }
        return from;
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doPlatformPluginList() throws IOException {
        SetupWizard setupWizard = Jenkins.get().getSetupWizard();
        if (setupWizard != null) {
            if (InstallState.UPGRADE.equals(Jenkins.get().getInstallState())) {
                JSONArray initialPluginData = this.getPlatformPluginUpdates();
                if (initialPluginData != null) {
                    return HttpResponses.okJSON(initialPluginData);
                }
            } else {
                JSONArray initialPluginData = this.getPlatformPluginList();
                if (initialPluginData != null) {
                    return HttpResponses.okJSON(initialPluginData);
                }
            }
        }
        return HttpResponses.okJSON();
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doRestartStatus() throws IOException {
        JSONObject response = new JSONObject();
        Jenkins jenkins = Jenkins.get();
        response.put("restartRequired", (Object)jenkins.getUpdateCenter().isRestartRequiredForCompletion());
        response.put("restartSupported", (Object)jenkins.getLifecycle().canRestart());
        return HttpResponses.okJSON(response);
    }

    @CheckForNull
    public JSONArray getPlatformPluginUpdates() {
        VersionNumber version = this.getCurrentLevel();
        if (version == null) {
            return null;
        }
        return this.getPlatformPluginsForUpdate(version, Jenkins.getVersion());
    }

    @CheckForNull
    JSONArray getPlatformPluginList() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONArray initialPluginList = null;
        for (UpdateSite updateSite : Jenkins.get().getUpdateCenter().getSiteList()) {
            Object suggestedPluginUrl = updateSite.getSuggestedPluginsUrl();
            VersionNumber version = Jenkins.getVersion();
            if (version != null && (((String)suggestedPluginUrl).startsWith("https://") || ((String)suggestedPluginUrl).startsWith("http://"))) {
                suggestedPluginUrl = (String)suggestedPluginUrl + (((String)suggestedPluginUrl).contains("?") ? "&" : "?") + "version=" + String.valueOf(version);
            }
            try {
                URLConnection connection = ProxyConfiguration.open(new URI((String)suggestedPluginUrl).toURL());
                try {
                    String initialPluginJson = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    JSONObject initialPluginObject = null;
                    if (connection instanceof HttpURLConnection) {
                        int responseCode = ((HttpURLConnection)connection).getResponseCode();
                        if (200 != responseCode) {
                            throw new HttpRetryException("Invalid response code (" + responseCode + ") from URL: " + (String)suggestedPluginUrl, responseCode);
                        }
                        if (DownloadService.signatureCheck) {
                            initialPluginObject = JSONObject.fromObject((Object)initialPluginJson);
                            FormValidation result = updateSite.verifySignatureInternal(initialPluginObject);
                            if (result.kind != FormValidation.Kind.OK) {
                                LOGGER.log(Level.WARNING, "Ignoring remote platform-plugins.json: " + result.getMessage());
                                throw result;
                            }
                        }
                    }
                    if (initialPluginObject != null) {
                        initialPluginList = initialPluginObject.getJSONArray("categories");
                        break;
                    }
                    try {
                        initialPluginList = JSONArray.fromObject((Object)initialPluginJson);
                    }
                    catch (RuntimeException ex) {
                        initialPluginList = JSONObject.fromObject((Object)initialPluginJson).getJSONArray("categories");
                    }
                    break;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (initialPluginList == null) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                URL localPluginData = cl.getResource("jenkins/install/platform-plugins.json");
                String initialPluginJson = IOUtils.toString((InputStream)localPluginData.openStream(), (Charset)StandardCharsets.UTF_8);
                initialPluginList = JSONArray.fromObject((Object)initialPluginJson);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return initialPluginList;
    }

    JSONArray getPlatformPluginsForUpdate(VersionNumber from, VersionNumber to) {
        Jenkins jenkins = Jenkins.get();
        JSONArray pluginCategories = JSONArray.fromObject((Object)this.getPlatformPluginList().toString());
        Iterator categoryIterator = pluginCategories.iterator();
        while (categoryIterator.hasNext()) {
            Object category = categoryIterator.next();
            if (!(category instanceof JSONObject)) continue;
            JSONObject cat = (JSONObject)category;
            JSONArray plugins = cat.getJSONArray("plugins");
            Iterator pluginIterator = plugins.iterator();
            while (pluginIterator.hasNext()) {
                VersionNumber v;
                String sinceVersion;
                JSONObject plugin;
                Object pluginData = pluginIterator.next();
                if (pluginData instanceof JSONObject && (plugin = (JSONObject)pluginData).has("added") && (sinceVersion = plugin.getString("added")) != null && (v = new VersionNumber(sinceVersion)).compareTo(to) <= 0 && v.compareTo(from) > 0) {
                    String pluginName = plugin.getString("name");
                    if (null == jenkins.getPluginManager().getPlugin(pluginName)) {
                        boolean foundCompatibleVersion = false;
                        for (UpdateSite site : jenkins.getUpdateCenter().getSiteList()) {
                            UpdateSite.Plugin sitePlug = site.getPlugin(pluginName);
                            if (sitePlug == null || sitePlug.isForNewerHudson() || sitePlug.isNeededDependenciesForNewerJenkins()) continue;
                            foundCompatibleVersion = true;
                            break;
                        }
                        if (foundCompatibleVersion) continue;
                    }
                }
                pluginIterator.remove();
            }
            if (!plugins.isEmpty()) continue;
            categoryIterator.remove();
        }
        return pluginCategories;
    }

    public FilePath getInitialAdminPasswordFile() {
        return Jenkins.get().getRootPath().child("secrets/initialAdminPassword");
    }

    @Restricted(value={NoExternalUse.class})
    public FilePath getInitialAdminApiTokenFile() {
        return Jenkins.get().getRootPath().child("secrets/initialAdminApiToken");
    }

    @RequirePOST
    public HttpResponse doCompleteInstall() throws IOException, ServletException {
        this.completeSetup();
        return HttpResponses.okJSON();
    }

    void completeSetup() throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        InstallUtil.saveLastExecVersion();
        this.setCurrentLevel(Jenkins.getVersion());
        InstallUtil.proceedToNextStateFrom(InstallState.INITIAL_SETUP_COMPLETED);
    }

    public List<InstallState> getInstallStates() {
        return InstallState.all();
    }

    public InstallState getInstallState(String name) {
        if (name == null) {
            return null;
        }
        return InstallState.valueOf(name);
    }

    public void onInstallStateUpdate(InstallState state) {
        if (state.isSetupComplete()) {
            this.tearDownFilter();
        } else {
            this.setUpFilter();
        }
    }

    public boolean hasSetupWizardFilter() {
        return PluginServletFilter.hasFilter(this.FORCE_SETUP_WIZARD_FILTER);
    }

    private void checkFilter() {
        if (!Jenkins.get().getInstallState().isSetupComplete()) {
            this.setUpFilter();
        }
    }
}

