/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.model.Hudson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import jenkins.ExtensionFilter;

public abstract class ExtensionComponentSet {
    public static final ExtensionComponentSet EMPTY = new ExtensionComponentSet(){

        @Override
        public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
            return Collections.emptyList();
        }
    };

    public abstract <T> Collection<ExtensionComponent<T>> find(Class<T> var1);

    public final ExtensionComponentSet filtered() {
        final ExtensionComponentSet base = this;
        return new ExtensionComponentSet(){

            @Override
            public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                ArrayList<ExtensionComponent<T>> a = new ArrayList<ExtensionComponent<T>>();
                for (ExtensionComponent<T> c : base.find(type)) {
                    if (!ExtensionFilter.isAllowed(type, c)) continue;
                    a.add(c);
                }
                return a;
            }
        };
    }

    public static ExtensionComponentSet union(final Collection<? extends ExtensionComponentSet> base) {
        return new ExtensionComponentSet(){

            @Override
            public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                ArrayList<ExtensionComponent<T>> r = new ArrayList<ExtensionComponent<T>>();
                for (ExtensionComponentSet d : base) {
                    r.addAll(d.find(type));
                }
                return r;
            }
        };
    }

    public static ExtensionComponentSet union(ExtensionComponentSet ... members) {
        return ExtensionComponentSet.union(Arrays.asList(members));
    }

    public static ExtensionComponentSet allOf(final ExtensionFinder f) {
        return new ExtensionComponentSet(){

            @Override
            public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                return f.find(type, Hudson.getInstance());
            }
        };
    }
}

