/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.InputManipulationException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.RobustReflectionConverter;
import hudson.util.XStream2SecurityUtils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import jenkins.util.xstream.CriticalXStreamException;
import org.jvnet.tiger_types.Types;

public class RobustCollectionConverter
extends CollectionConverter {
    private final SerializableConverter sc;
    @CheckForNull
    private final Class<?> elementType;

    public RobustCollectionConverter(XStream xs) {
        this(xs.getMapper(), xs.getReflectionProvider(), null);
    }

    public RobustCollectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this(mapper, reflectionProvider, null);
    }

    public RobustCollectionConverter(Mapper mapper, ReflectionProvider reflectionProvider, Type collectionType) {
        super(mapper);
        this.sc = new SerializableConverter(mapper, reflectionProvider, new ClassLoaderReference(null));
        if (collectionType != null && Collection.class.isAssignableFrom(Types.erasure((Type)collectionType))) {
            Type baseType = Types.getBaseClass((Type)collectionType, Collection.class);
            Type typeArg = Types.getTypeArgument((Type)baseType, (int)0, Object.class);
            this.elementType = Types.erasure((Type)typeArg);
        } else {
            this.elementType = null;
        }
    }

    public boolean canConvert(Class type) {
        return super.canConvert(type) || type == CopyOnWriteArrayList.class || type == CopyOnWriteArraySet.class;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String s = reader.getAttribute("serialization");
        if (s != null && s.equals("custom")) {
            return this.sc.unmarshal(reader, context);
        }
        return super.unmarshal(reader, context);
    }

    protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            try {
                Object item = this.readBareItem(reader, context, collection);
                if (this.elementType != null && item != null && !this.elementType.isInstance(item)) {
                    ConversionException exception = new ConversionException("Invalid type for collection element");
                    exception.add("required-type", this.elementType.getName());
                    exception.add("class", item.getClass().getName());
                    exception.add("converter-type", ((Object)((Object)this)).getClass().getName());
                    reader.appendErrors((ErrorWriter)exception);
                    RobustReflectionConverter.addErrorInContext(context, exception);
                } else {
                    long nanoNow = System.nanoTime();
                    collection.add(item);
                    XStream2SecurityUtils.checkForCollectionDoSAttack(context, nanoNow);
                }
            }
            catch (CriticalXStreamException e) {
                throw e;
            }
            catch (InputManipulationException e) {
                Logger.getLogger(RobustCollectionConverter.class.getName()).warning("DoS detected and prevented. If the heuristic was too aggressive, you can customize the behavior by setting the hudson.util.XStream2.collectionUpdateLimit system property. See https://www.jenkins.io/redirect/xstream-dos-prevention for more information.");
                throw new CriticalXStreamException((XStreamException)((Object)e));
            }
            catch (XStreamException | LinkageError e) {
                RobustReflectionConverter.addErrorInContext(context, e);
            }
            reader.moveUp();
        }
    }
}

