/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.tools.AbstractCommandInstaller;
import hudson.tools.Messages;
import hudson.util.LineEndingConversion;
import java.io.ObjectStreamException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class BatchCommandInstaller
extends AbstractCommandInstaller {
    @DataBoundConstructor
    public BatchCommandInstaller(String label, String command, String toolHome) {
        super(label, LineEndingConversion.convertEOL(command, LineEndingConversion.EOLType.Windows), toolHome);
    }

    @Override
    public String getCommandFileExtension() {
        return ".bat";
    }

    @Override
    public String[] getCommandCall(FilePath script) {
        return new String[]{"cmd", "/c", "call", script.getRemote()};
    }

    private Object readResolve() throws ObjectStreamException {
        return new BatchCommandInstaller(this.getLabel(), this.getCommand(), this.getToolHome());
    }

    @Extension
    @Symbol(value={"batchFile"})
    public static class DescriptorImpl
    extends AbstractCommandInstaller.Descriptor<BatchCommandInstaller> {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.BatchCommandInstaller_DescriptorImpl_displayName();
        }
    }
}

