/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import java.io.IOException;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArchitectureMonitor
extends NodeMonitor {
    @DataBoundConstructor
    public ArchitectureMonitor() {
    }

    private static class GetArchTask
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private GetArchTask() {
        }

        public String call() {
            String os = System.getProperty("os.name");
            String arch = System.getProperty("os.arch");
            return os + " (" + arch + ")";
        }
    }

    @Extension
    @Symbol(value={"architecture"})
    public static final class DescriptorImpl
    extends AbstractAsyncNodeMonitorDescriptor<String> {
        @Override
        protected Callable<String, IOException> createCallable(Computer c) {
            return new GetArchTask();
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ArchitectureMonitor_DisplayName();
        }

        @Override
        public boolean canTakeOffline() {
            return false;
        }
    }
}

