/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.Api;
import hudson.model.Messages;
import hudson.model.TimeSeries;
import hudson.util.ChartUtil;
import hudson.util.NoOverlapCategoryAxis;
import jakarta.servlet.ServletException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class MultiStageTimeSeries
implements Serializable {
    public final Localizable title;
    public final Color color;
    @Exported
    public final TimeSeries sec10;
    @Exported
    public final TimeSeries min;
    @Exported
    public final TimeSeries hour;
    private int counter;
    private static final Font CHART_FONT = Font.getFont(MultiStageTimeSeries.class.getName() + ".chartFont", new Font("SansSerif", 0, 10));
    private static final long serialVersionUID = 1L;

    public MultiStageTimeSeries(Localizable title, Color color, float initialValue, float decay) {
        this.title = title;
        this.color = color;
        this.sec10 = new TimeSeries(initialValue, decay, 6 * (int)TimeUnit.HOURS.toMinutes(6L));
        this.min = new TimeSeries(initialValue, decay, (int)TimeUnit.DAYS.toMinutes(2L));
        this.hour = new TimeSeries(initialValue, decay, (int)TimeUnit.DAYS.toHours(56L));
    }

    @Deprecated
    public MultiStageTimeSeries(float initialValue, float decay) {
        this(Messages._MultiStageTimeSeries_EMPTY_STRING(), Color.WHITE, initialValue, decay);
    }

    public void update(float f) {
        this.counter = (this.counter + 1) % 360;
        this.sec10.update(f);
        if (this.counter % 6 == 0) {
            this.min.update(f);
        }
        if (this.counter == 0) {
            this.hour.update(f);
        }
    }

    public TimeSeries pick(TimeScale timeScale) {
        switch (timeScale) {
            case HOUR: {
                return this.hour;
            }
            case MIN: {
                return this.min;
            }
            case SEC10: {
                return this.sec10;
            }
        }
        throw new AssertionError();
    }

    public float getLatest(TimeScale timeScale) {
        return this.pick(timeScale).getLatest();
    }

    public Api getApi() {
        return new Api(this);
    }

    public static TrendChart createTrendChart(TimeScale scale, MultiStageTimeSeries ... data) {
        return new TrendChart(scale, data);
    }

    public static enum TimeScale {
        SEC10(TimeUnit.SECONDS.toMillis(10L)),
        MIN(TimeUnit.MINUTES.toMillis(1L)),
        HOUR(TimeUnit.HOURS.toMillis(1L));

        public final long tick;

        private TimeScale(long tick) {
            this.tick = tick;
        }

        public DateFormat createDateFormat() {
            switch (this) {
                case HOUR: {
                    return new SimpleDateFormat("MMM/dd HH");
                }
                case MIN: {
                    return new SimpleDateFormat("E HH:mm");
                }
                case SEC10: {
                    return new SimpleDateFormat("HH:mm:ss");
                }
            }
            throw new AssertionError();
        }

        public static TimeScale parse(String type) {
            if (type == null) {
                return MIN;
            }
            return Enum.valueOf(TimeScale.class, type.toUpperCase(Locale.ENGLISH));
        }
    }

    public static class TrendChart
    implements HttpResponse {
        public final TimeScale timeScale;
        public final List<MultiStageTimeSeries> series;
        public final DefaultCategoryDataset dataset;

        public TrendChart(TimeScale timeScale, MultiStageTimeSeries ... series) {
            this.timeScale = timeScale;
            this.series = new ArrayList<MultiStageTimeSeries>(Arrays.asList(series));
            this.dataset = this.createDataset();
        }

        protected DefaultCategoryDataset createDataset() {
            float[][] dataPoints = new float[this.series.size()][];
            for (int i = 0; i < this.series.size(); ++i) {
                dataPoints[i] = this.series.get(i).pick(this.timeScale).getHistory();
            }
            int dataLength = dataPoints[0].length;
            for (float[] dataPoint : dataPoints) {
                assert (dataLength == dataPoint.length);
            }
            DefaultCategoryDataset ds = new DefaultCategoryDataset();
            DateFormat format = this.timeScale.createDateFormat();
            Date dt = new Date(System.currentTimeMillis() - this.timeScale.tick * (long)dataLength);
            for (int i = dataLength - 1; i >= 0; --i) {
                dt = new Date(dt.getTime() + this.timeScale.tick);
                String l = format.format(dt);
                for (int j = 0; j < dataPoints.length; ++j) {
                    ds.addValue((double)dataPoints[j][i], (Comparable)((Object)this.series.get((int)j).title.toString()), (Comparable)((Object)l));
                }
            }
            return ds;
        }

        public JFreeChart createChart() {
            JFreeChart chart = ChartFactory.createLineChart(null, null, null, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            chart.getLegend().setItemFont(CHART_FONT);
            CategoryPlot plot = chart.getCategoryPlot();
            this.configurePlot(plot);
            this.configureRangeAxis((NumberAxis)plot.getRangeAxis());
            this.crop(plot);
            return chart;
        }

        protected void configureRangeAxis(NumberAxis rangeAxis) {
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            rangeAxis.setTickLabelFont(CHART_FONT);
            rangeAxis.setLabelFont(CHART_FONT);
        }

        protected void crop(CategoryPlot plot) {
            plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        }

        protected CategoryAxis configureDomainAxis(CategoryPlot plot) {
            NoOverlapCategoryAxis domainAxis = new NoOverlapCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            domainAxis.setLabelFont(CHART_FONT);
            domainAxis.setTickLabelFont(CHART_FONT);
            return domainAxis;
        }

        protected void configureRenderer(LineAndShapeRenderer renderer) {
            renderer.setBaseStroke((Stroke)new BasicStroke(3.0f));
            for (int i = 0; i < this.series.size(); ++i) {
                renderer.setSeriesPaint(i, (Paint)this.series.get((int)i).color);
            }
        }

        protected void configurePlot(CategoryPlot plot) {
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            this.configureRenderer((LineAndShapeRenderer)plot.getRenderer());
            this.configureDomainAxis(plot);
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
            ChartUtil.generateGraph(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp), this.createChart(), 500, 400);
        }
    }
}

