/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.View;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.security.ExtendedReadRedaction;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Argument;

@Extension
public class GetViewCommand
extends CLICommand {
    @Argument(usage="Name of the view to obtain", required=true)
    private View view;

    @Override
    public String getShortDescription() {
        return Messages.GetViewCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        this.view.checkPermission(View.READ);
        if (this.view.hasPermission(View.CONFIGURE)) {
            this.view.writeXml(this.stdout);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.view.writeXml(baos);
            String xml = baos.toString(StandardCharsets.UTF_8);
            xml = ExtendedReadRedaction.applyAll(xml);
            IOUtils.write((String)xml, (OutputStream)this.stdout, (Charset)StandardCharsets.UTF_8);
        }
        return 0;
    }
}

