/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.AbstractMarkupText;
import hudson.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MarkupText
extends AbstractMarkupText {
    private final String text;
    private final List<Tag> tags = new ArrayList<Tag>();

    public MarkupText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public SubText subText(int start, int end) {
        return new SubText(start, end < 0 ? this.text.length() + 1 + end : end);
    }

    @Override
    public void addMarkup(int startPos, int endPos, String startTag, String endTag) {
        this.rangeCheck(startPos);
        this.rangeCheck(endPos);
        if (startPos > endPos) {
            throw new IndexOutOfBoundsException();
        }
        this.tags.add(new Tag(startPos, startTag));
        this.tags.add(0, new Tag(endPos, endTag));
    }

    public void addMarkup(int pos, String tag) {
        this.rangeCheck(pos);
        this.tags.add(new Tag(pos, tag));
    }

    private void rangeCheck(int pos) {
        if (pos < 0 || pos > this.text.length()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Deprecated
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean preEscape) {
        if (this.tags.isEmpty()) {
            return preEscape ? Util.xmlEscape(this.text) : Util.escape(this.text);
        }
        Collections.sort(this.tags);
        StringBuilder buf = new StringBuilder();
        int copied = 0;
        for (Tag tag : this.tags) {
            if (copied < tag.pos) {
                String portion = this.text.substring(copied, tag.pos);
                buf.append(preEscape ? Util.xmlEscape(portion) : Util.escape(portion));
                copied = tag.pos;
            }
            buf.append(tag.markup);
        }
        if (copied < this.text.length()) {
            String portion = this.text.substring(copied);
            buf.append(preEscape ? Util.xmlEscape(portion) : Util.escape(portion));
        }
        return buf.toString();
    }

    @Override
    public List<SubText> findTokens(Pattern pattern) {
        return super.findTokens(pattern);
    }

    @Override
    protected SubText createSubText(Matcher m) {
        return new SubText(m, 0);
    }

    public final class SubText
    extends AbstractMarkupText {
        private final int start;
        private final int end;
        private final int[] groups;

        public SubText(Matcher m, int textOffset) {
            this.start = m.start() + textOffset;
            this.end = m.end() + textOffset;
            int cnt = m.groupCount();
            this.groups = new int[cnt * 2];
            for (int i = 0; i < cnt; ++i) {
                this.groups[i * 2] = m.start(i + 1) + textOffset;
                this.groups[i * 2 + 1] = m.end(i + 1) + textOffset;
            }
        }

        public SubText(int start, int end) {
            this.start = start;
            this.end = end;
            this.groups = new int[0];
        }

        @Override
        public SubText subText(int start, int end) {
            return MarkupText.this.subText(this.start + start, end < 0 ? this.end + 1 + end : this.start + end);
        }

        @Override
        public String getText() {
            return MarkupText.this.text.substring(this.start, this.end);
        }

        @Override
        public void addMarkup(int startPos, int endPos, String startTag, String endTag) {
            MarkupText.this.addMarkup(startPos + this.start, endPos + this.start, startTag, endTag);
        }

        public void surroundWith(String startTag, String endTag) {
            this.addMarkup(0, this.length(), this.replace(startTag), this.replace(endTag));
        }

        public void surroundWithLiteral(String startTag, String endTag) {
            this.addMarkup(0, this.length(), startTag, endTag);
        }

        public void href(String url) {
            this.addHyperlink(0, this.length(), url);
        }

        public int start(int groupIndex) {
            if (groupIndex == 0) {
                return this.start;
            }
            return this.groups[groupIndex * 2 - 2];
        }

        public int start() {
            return this.start;
        }

        public int end(int groupIndex) {
            if (groupIndex == 0) {
                return this.end;
            }
            return this.groups[groupIndex * 2 - 1];
        }

        public int end() {
            return this.end;
        }

        public String group(int groupIndex) {
            if (this.start(groupIndex) == -1) {
                return null;
            }
            return MarkupText.this.text.substring(this.start(groupIndex), this.end(groupIndex));
        }

        public int groupCount() {
            return this.groups.length / 2;
        }

        public String replace(String s) {
            StringBuilder buf = new StringBuilder(s.length() + 10);
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '\\') {
                    buf.append(s.charAt(++i));
                    continue;
                }
                if (ch == '$') {
                    int groupId;
                    if ((groupId = (ch = s.charAt(++i)) - 48) < 0 || groupId > 9) {
                        buf.append('$').append(ch);
                        continue;
                    }
                    String group = this.group(groupId);
                    if (group == null) continue;
                    buf.append(group);
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }

        @Override
        protected SubText createSubText(Matcher m) {
            return new SubText(m, this.start);
        }
    }

    private static final class Tag
    implements Comparable<Tag> {
        private final int pos;
        private final String markup;

        Tag(int pos, String markup) {
            this.pos = pos;
            this.markup = markup;
        }

        @Override
        public int compareTo(Tag that) {
            return this.pos - that.pos;
        }
    }
}

