/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Node;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.util.RunHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="2.1")
public class EnvInjectVariableGetter {
    private static Logger LOG = Logger.getLogger(EnvInjectVariableGetter.class.getName());

    @Deprecated
    public EnvInjectVariableGetter() {
    }

    @Deprecated
    @NonNull
    public Map<String, String> getJenkinsSystemVariables(boolean forceOnMaster) throws IOException, InterruptedException {
        return EnvInjectVariableGetter.getJenkinsSystemEnvVars(forceOnMaster);
    }

    @NonNull
    public static Map<String, String> getJenkinsSystemEnvVars(boolean forceOnMaster) throws IOException, InterruptedException {
        String rootUrl;
        EnvVars result = new TreeMap();
        Jenkins jenkins = Jenkins.get();
        Computer computer = forceOnMaster ? jenkins.toComputer() : Computer.currentComputer();
        if (computer != null) {
            result = computer.getEnvironment().overrideAll(result);
            if (computer instanceof Jenkins.MasterComputer) {
                result.put("NODE_NAME", Jenkins.get().getSelfLabel().getName());
            } else {
                result.put("NODE_NAME", computer.getName());
            }
            Node n = computer.getNode();
            if (n != null) {
                result.put("NODE_LABELS", Util.join((Collection)n.getAssignedLabels(), (String)" "));
            }
        }
        if ((rootUrl = jenkins.getRootUrl()) != null) {
            result.put("JENKINS_URL", rootUrl);
            result.put("HUDSON_URL", rootUrl);
        }
        result.put("JENKINS_HOME", jenkins.getRootDir().getPath());
        result.put("HUDSON_HOME", jenkins.getRootDir().getPath());
        return result;
    }

    public Map<String, String> getBuildVariables(@NonNull AbstractBuild build, @NonNull EnvInjectLogger logger) throws EnvInjectException {
        return RunHelper.getBuildVariables(build, logger);
    }

    @Deprecated
    @CheckForNull
    public EnvInjectJobProperty getEnvInjectJobProperty(@NonNull AbstractBuild build) {
        return RunHelper.getEnvInjectJobProperty(build);
    }

    @Deprecated
    @NonNull
    public Map<String, String> getEnvVarsPreviousSteps(@NonNull AbstractBuild build, @NonNull EnvInjectLogger logger) throws IOException, InterruptedException, EnvInjectException {
        return RunHelper.getEnvVarsPreviousSteps(build, logger);
    }
}

