/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Api;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean(defaultVisibility=99)
public class EnvInjectVarList
implements Serializable {
    @NonNull
    private final Map<String, String> envVars = new TreeMap<String, String>();
    public static final EnvInjectVarList HIDDEN = new Hidden();

    public EnvInjectVarList(Map<String, String> envMap) {
        if (envMap != null) {
            this.envVars.putAll(envMap);
        }
    }

    @Exported
    public Map<String, String> getEnvMap() {
        return this.envVars;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @RequirePOST
    public void doExport(@NonNull StaplerRequest request, @NonNull StaplerResponse response) throws IOException {
        String path = request.getPathInfo();
        if (path != null) {
            this.doExportWithPath(path, request, response);
            return;
        }
        this.doExportHeaders(request, response);
    }

    private void doExportWithPath(@NonNull String path, @NonNull StaplerRequest request, @NonNull StaplerResponse response) throws IOException {
        if (path.endsWith("text")) {
            this.writeTextResponse(response);
            return;
        }
        if (path.endsWith("xml")) {
            this.writeXmlResponse(response);
            return;
        }
        if (path.endsWith("json")) {
            this.writeJsonResponse(response);
            return;
        }
        this.doExportHeaders(request, response);
    }

    private void doExportHeaders(@NonNull StaplerRequest request, @NonNull StaplerResponse response) throws IOException {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            this.writeTextResponse(response);
            return;
        }
        if (acceptHeader.contains("application/xml")) {
            this.writeXmlResponse(response);
            return;
        }
        if (acceptHeader.contains("application/json")) {
            this.writeJsonResponse(response);
            return;
        }
        this.writeTextResponse(response);
    }

    private void writeTextResponse(@NonNull StaplerResponse response) throws IOException {
        response.setContentType("plain/text");
        StringWriter stringWriter = new StringWriter();
        for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
            stringWriter.write(String.format("%s%s%s%n", entry.getKey(), "=", entry.getValue()));
        }
        response.getOutputStream().write(stringWriter.toString().getBytes());
    }

    private void writeXmlResponse(@NonNull StaplerResponse response) throws IOException {
        response.setContentType("application/xml");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write("<envVars>".getBytes());
        for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
            outputStream.write(String.format("<envVar name=\"%s\" value=\"%s\"/>", this.escapeXml(entry.getKey()), this.escapeXml(entry.getValue())).getBytes());
        }
        outputStream.write("</envVars>".getBytes());
    }

    private void writeJsonResponse(@NonNull StaplerResponse response) throws IOException {
        response.setContentType("application/json");
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write("{\"envVars\": { \"envVar\":[".getBytes());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.envVars.entrySet()) {
            sb.append(String.format(", {\"name\":\"%s\", \"value\":\"%s\"}", this.escapeJson(entry.getKey()), this.escapeJson(entry.getValue())));
        }
        sb.delete(0, 1);
        outputStream.write(sb.toString().getBytes());
        outputStream.write("]}}".getBytes());
    }

    private String escapeXml(String xml) {
        return xml.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    private String escapeJson(String json) {
        return json.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static class Hidden
    extends EnvInjectVarList {
        private static final long serialVersionUID = 1L;

        public Hidden() {
            super(Collections.emptyMap());
        }
    }
}

