/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.EnvironmentContributingAction;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.lib.envinject.EnvInjectAction;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectPlugin;
import org.jenkinsci.plugins.envinject.EnvInjectVarList;
import org.jenkinsci.plugins.envinject.util.RunHelper;

public class EnvInjectPluginAction
extends EnvInjectAction
implements EnvironmentContributingAction {
    private static final Logger LOGGER = Logger.getLogger(EnvInjectPluginAction.class.getName());
    @GuardedBy(value="this")
    private transient EnvVars resolvedParameterEnvVars = null;

    @Deprecated
    public EnvInjectPluginAction(@NonNull AbstractBuild build, @CheckForNull Map<String, String> envMap) {
        super(build, envMap);
    }

    public EnvInjectPluginAction(@CheckForNull Map<String, String> envMap) {
        super(envMap);
    }

    public String getIconFileName() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.getOwner())) {
            return null;
        }
        return super.getIconFileName();
    }

    public String getUrlName() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.getOwner())) {
            return null;
        }
        return super.getUrlName();
    }

    public Object getTarget() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.getOwner())) {
            return EnvInjectVarList.HIDDEN;
        }
        return this.getEnvInjectVarList();
    }

    @NonNull
    private EnvInjectVarList getEnvInjectVarList() {
        Map currentEnvMap = this.getEnvMap();
        if (currentEnvMap == null) {
            return new EnvInjectVarList(Collections.emptyMap());
        }
        return new EnvInjectVarList(Maps.transformEntries((Map)currentEnvMap, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                Set sensibleVars = EnvInjectPluginAction.this.getSensibleVariables();
                return sensibleVars != null && sensibleVars.contains(key) ? "[*******]" : value;
            }
        }));
    }

    @CheckForNull
    private synchronized EnvVars getParameterEnvVars() {
        Run run = this.getOwner();
        if (this.resolvedParameterEnvVars == null && run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            EnvVars resolvedParameters = new EnvVars();
            List actions = build.getActions(ParametersAction.class);
            for (ParametersAction params : actions) {
                params.buildEnvironment((Run)build, resolvedParameters);
            }
            this.resolvedParameterEnvVars = resolvedParameters;
        }
        return this.resolvedParameterEnvVars;
    }

    public synchronized void buildEnvVars(@NonNull AbstractBuild<?, ?> build, @NonNull EnvVars env) {
        assert (build == this.getOwner()) : "Trying to resolve environment for build, which is not an owner of this action";
        Map currentEnvMap = this.getEnvMap();
        if (currentEnvMap == null) {
            return;
        }
        HashMap<String, String> overrides = null;
        for (Map.Entry storedVar : currentEnvMap.entrySet()) {
            String parameterValue;
            String varName = (String)storedVar.getKey();
            String storedValue = (String)storedVar.getValue();
            String envValue = (String)env.get((Object)varName);
            if (envValue == null) {
                LOGGER.log(Level.CONFIG, "Build {0}: Variable {1} is missing, overriding it by value stored in the action", new Object[]{build, varName});
                env.put(varName, storedValue);
                continue;
            }
            if (envValue.equals(storedValue)) continue;
            EnvVars parameterEnvVars = this.getParameterEnvVars();
            boolean usedExternalValue = true;
            if (parameterEnvVars != null && envValue.equals(parameterValue = (String)parameterEnvVars.get((Object)varName))) {
                EnvInjectJobProperty prop = RunHelper.getEnvInjectJobProperty(build);
                if (prop != null && prop.isOverrideBuildParameters()) {
                    LOGGER.log(Level.CONFIG, "Build {0}: Overriding value of {1} defined by the parameter value", new Object[]{build, varName});
                    env.put(varName, storedValue);
                    usedExternalValue = false;
                } else {
                    LOGGER.log(Level.CONFIG, "Build {0}: Build variable {1} will not be overridden, overriding value stored in the action", new Object[]{build, varName});
                    if (overrides == null) {
                        overrides = new HashMap();
                    }
                    overrides.put(varName, envValue);
                }
            }
            if (!usedExternalValue) continue;
            LOGGER.log(Level.CONFIG, "Build {0}: Variable {1} is defined externally, overriding value stored in the action", new Object[]{build, varName});
            if (overrides == null) {
                overrides = new HashMap<String, String>();
            }
            overrides.put(varName, envValue);
        }
        if (overrides != null) {
            LOGGER.log(Level.FINER, "Build {0}: Overriding {1} variables, which have been changed since the previous run", new Object[]{build, overrides.size()});
            this.overrideAll(RunHelper.getSensitiveBuildVariables(build), overrides);
        }
    }
}

