/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.envinject.EnvInjectGlobalPasswordEntry;
import org.jenkinsci.plugins.envinject.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class EnvInjectNodeProperty
extends NodeProperty<Node> {
    private boolean unsetSystemVariables;
    @CheckForNull
    private final String propertiesFilePath;

    @DataBoundConstructor
    public EnvInjectNodeProperty(boolean unsetSystemVariables, String propertiesFilePath) {
        this.unsetSystemVariables = unsetSystemVariables;
        this.propertiesFilePath = Util.fixEmpty((String)propertiesFilePath);
    }

    public boolean isUnsetSystemVariables() {
        return this.unsetSystemVariables;
    }

    @CheckForNull
    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    @Extension
    public static class EnvInjectNodePropertyDescriptor
    extends NodePropertyDescriptor {
        @NonNull
        private EnvInjectGlobalPasswordEntry[] envInjectGlobalPasswordEntries = new EnvInjectGlobalPasswordEntry[0];
        public static final String ENVINJECT_CONFIG = "envInject";

        public EnvInjectNodePropertyDescriptor() {
            this.load();
        }

        public EnvInjectNodePropertyDescriptor(Class<? extends NodeProperty<?>> clazz) {
            super(clazz);
            this.load();
        }

        public String getDisplayName() {
            return Messages.envinject_nodeProperty_displayName();
        }

        public String getHelpFile() {
            return "/plugin/envinject/help-node.html";
        }

        public EnvInjectGlobalPasswordEntry[] getEnvInjectGlobalPasswordEntries() {
            return Arrays.copyOf(this.envInjectGlobalPasswordEntries, this.envInjectGlobalPasswordEntries.length);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            List envInjectGlobalPasswordEntriesList = req.bindParametersToList(EnvInjectGlobalPasswordEntry.class, "envInject.");
            this.envInjectGlobalPasswordEntries = envInjectGlobalPasswordEntriesList.toArray(new EnvInjectGlobalPasswordEntry[envInjectGlobalPasswordEntriesList.size()]);
            this.save();
            return true;
        }

        public String getId() {
            return ENVINJECT_CONFIG;
        }
    }
}

